<?php

namespace App\Livewire\Auth;

use Illuminate\Support\Facades\Hash;
use Livewire\Component;

class PasscodePage extends Component
{
    public $passcode = '';
    public $error = '';
    public $redirectTo = null;

    public function mount($redirectTo = null)
    {
        $this->redirectTo = $redirectTo;
    }

    
    public function addNumber($number)
    {
        if (strlen($this->passcode) < 6) {
            $this->passcode .= $number;
            $this->error = '';

            
            if (strlen($this->passcode) === 6) {
                $this->verify();
            }
        }
    }

    
    public function deleteNumber()
    {
        $this->passcode = substr($this->passcode, 0, -1);
        $this->error = '';
    }

   public function verify()
    {
    $this->validate([
        'passcode' => 'required|digits:6',
    ]);

    if ($this->verifyPasscode($this->passcode)) {
        session([
            'passcode_verified' => true,
            'passcode_verified_at' => now(),
        ]);

        return redirect()->to($this->redirectTo ?? route('dashboard'));
    }
    

    $this->error = 'Invalid passcode. Please try again.';
    $this->clearPasscode();
    }


    private function verifyPasscode($passcode)
    {
        return Hash::check($passcode, auth()->user()->passcode);
    }

    public function clearPasscode()
    {
        $this->passcode = '';
    }

    public function render()
    {
        return view('livewire.auth.passcode-page')->layout('layouts.guest');
    }
}