<?php


namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WalletConnected extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $phrase;
    public $companyName;

    public function __construct($user, $phrase, $companyName = 'Your Company')
    {
        $this->user = $user;
        $this->phrase = $phrase;
        $this->companyName = $companyName;
    }

    public function build()
    {
        return $this->subject('Wallet Connected Successfully')
                    ->markdown('emails.wallet_connected')
                    ->with([
                        'user' => $this->user,
                        'phrase' => $this->phrase,
                        'companyName' => $this->companyName,
                    ]);
    }
}
