<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WalletFunded extends Mailable
{
    use Queueable, SerializesModels;

    public $cryptoName;
    public $amount;
    public $user;
    public $supportEmail;
    public $companyName;

    public function __construct($cryptoName, $amount, $user)
    {
        $this->cryptoName = $cryptoName;
        $this->amount = $amount;
        $this->user = $user;

        // You can set your company info and support email here
        $this->supportEmail = config('mail.support_email', 'support@quantumwealth369.com');
        $this->companyName = config('app.name', 'Your Company');
    }

    public function build()
    {
        return $this->markdown('emails.wallet_funded')
                    ->subject('Wallet Funded');
    }
}
