document.addEventListener('DOMContentLoaded', () => {
    const darkModeToggle = document.getElementById('darkModeToggle');
    const html = document.documentElement;
    
    // Function to initialize/update the TradingView widget with proper theme
    function updateTradingViewTheme(isDark) {
        const tvTheme = isDark ? "dark" : "light";
        const bgColor = isDark ? "#131722" : "#F5F5F5";
        const toolbarBg = isDark ? "#1C2638" : "#FFFFFF";
        
        // Only reinitialize if chart exists
        if (document.getElementById('chart')) {
            initTradingViewChart(`${currentBaseSymbol}/USDT`, currentInterval);
        }
    }

    // Function to set dark mode and update UI accordingly
    function setDarkMode(isDark) {
        localStorage.setItem('darkMode', isDark);
        html.classList.toggle('dark', isDark);
        updateTradingViewTheme(isDark);
    }

    // Check for saved user preference, if any, on load
    const savedDarkMode = localStorage.getItem('darkMode');
    
    // Set initial dark mode state
    if (savedDarkMode === 'true' || (!savedDarkMode && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        setDarkMode(true);
    } else {
        setDarkMode(false);
    }

    // Listen for system dark mode changes
    const darkModeMediaQuery = window.matchMedia('(prefers-color-scheme: dark)');
    darkModeMediaQuery.addListener((e) => {
        if (localStorage.getItem('darkMode') === null) {  // Only react if user hasn't set preference
            setDarkMode(e.matches);
        }
    });

    // Toggle dark mode on button click
    if (darkModeToggle) {
        darkModeToggle.addEventListener('click', () => {
            setDarkMode(!html.classList.contains('dark'));
        });
    }

    // Watch for class changes on HTML element (in case dark mode is toggled elsewhere)
    const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
            if (mutation.attributeName === 'class') {
                updateTradingViewTheme(html.classList.contains('dark'));
            }
        });
    });

    observer.observe(html, {
        attributes: true,
        attributeFilter: ['class']
    });
});
        
        document.addEventListener('DOMContentLoaded', function() {
    function updateProfileNotificationBadge() {
        fetch('/notifications/unread-count')
            .then(response => response.json())
            .then(data => {
                const badge = document.getElementById('mobile-profile-notification-badge');
                if (data.count > 0) {
                    badge.textContent = data.count > 9 ? '9+' : data.count;
                    badge.classList.remove('hidden');
                } else {
                    badge.classList.add('hidden');
                }
            })
            .catch(error => console.error('Error fetching notification count:', error));
    }

    // Initial load
    updateProfileNotificationBadge();

    // Periodic updates every 5 minutes
    setInterval(updateProfileNotificationBadge, 5 * 60 * 1000);
});

document.addEventListener('DOMContentLoaded', function() {
    function updateSidebarNotificationBadge() {
        fetch('/notifications/unread-count')
            .then(response => response.json())
            .then(data => {
                const badge = document.getElementById('sidebar-notification-badge');
                if (data.count > 0) {
                    badge.textContent = data.count > 9 ? '9+' : data.count;
                    badge.classList.remove('hidden');
                } else {
                    badge.classList.add('hidden');
                }
            })
            .catch(error => console.error('Error fetching notification count:', error));
    }

    // Initial load
    updateSidebarNotificationBadge();

    // Periodic updates every 5 minutes
    setInterval(updateSidebarNotificationBadge, 5 * 60 * 1000);
});

function toggleModal(modalId) {
        const modal = document.getElementById(modalId);
        modal.classList.toggle('hidden');
    }

    document.getElementById('closeSendModal').onclick = function() {
        toggleModal('sendModal');
    };

    document.getElementById('closeReceiveModal').onclick = function() {
        toggleModal('receiveModal');
    };

    window.addEventListener('click', function(event) {
        const sendModal = document.getElementById('sendModal');
        const receiveModal = document.getElementById('receiveModal');

        if (event.target === sendModal) {
            sendModal.classList.add('hidden');
        }

        if (event.target === receiveModal) {
            receiveModal.classList.add('hidden');
        }
    });
        