<x-guest-layout>
    <div class="min-h-screen w-full bg-gradient-to-br from-gray-50 via-white to-gray-100 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 p-4 sm:p-6 md:p-8 flex items-center justify-center">
        <!-- Animated background elements -->
        <div class="fixed top-20 left-20 w-24 h-24 bg-yellow-400/20 rounded-full animate-pulse"></div>
        <div class="fixed bottom-20 right-20 w-16 h-16 bg-yellow-500/20 rounded-full animate-bounce delay-300"></div>
        <div class="fixed top-1/3 right-1/4 w-12 h-12 bg-yellow-300/20 rounded-full animate-ping"></div>

        <div class="w-full max-w-xl animate-fadeIn">
            <!-- Card Container -->
            <div class="relative bg-white dark:bg-gray-800 rounded-3xl shadow-xl p-8 border border-gray-100 dark:border-gray-700 transition-all duration-300 hover:shadow-2xl transform hover:-translate-y-1">
                <!-- Decorative Elements -->
                <div class="absolute -top-8 -right-8 w-32 h-32 bg-yellow-400/20 dark:bg-yellow-600/10 rounded-full blur-3xl animate-pulse"></div>
                <div class="absolute -bottom-8 -left-8 w-32 h-32 bg-yellow-500/20 dark:bg-yellow-500/10 rounded-full blur-3xl animate-pulse delay-150"></div>
                
                <!-- Content -->
                <div class="relative">
                    <!-- Header with icon -->
                    <div class="text-center mb-8 animate-slideDown">
                        <div class="inline-flex items-center justify-center w-16 h-16 mb-4 rounded-full bg-yellow-100 dark:bg-yellow-900/30">
                            <a href="{{url('/')}}">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 text-yellow-500 dark:text-yellow-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z" />
                            </svg>
                            </a>
                        </div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">Create Account</h1>
                        <p class="text-gray-600 dark:text-gray-400">Join us today</p>
                    </div>

                    <!-- Registration Form -->
                    <form method="POST" action="{{ route('register') }}" class="space-y-4">
                        @csrf

                        <!-- Name -->
                        <div class="space-y-2 animate-slideUp" style="animation-delay: 100ms;">
                            <x-input-label for="name" :value="__('Name')" class="text-sm font-medium text-gray-700 dark:text-gray-300" />
                            <div class="relative group">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                    </svg>
                                </div>
                                <input 
                                    id="name"
                                    type="text"
                                    name="name"
                                    value="{{ old('name') }}"
                                    required
                                    autofocus
                                    class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-600 focus:border-transparent dark:text-gray-200 text-sm transition-all duration-300 placeholder-gray-400 dark:placeholder-gray-500 group-hover:border-yellow-500 dark:group-hover:border-yellow-600"
                                    placeholder="John Doe"
                                />
                            </div>
                            <x-input-error :messages="$errors->get('name')" class="mt-1" />
                        </div>

                        <!-- Email -->
                        <div class="space-y-2 animate-slideUp" style="animation-delay: 200ms;">
                            <x-input-label for="email" :value="__('Email')" class="text-sm font-medium text-gray-700 dark:text-gray-300" />
                            <div class="relative group">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                    </svg>
                                </div>
                                <input 
                                    id="email"
                                    type="email"
                                    name="email"
                                    value="{{ old('email') }}"
                                    required
                                    class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-600 focus:border-transparent dark:text-gray-200 text-sm transition-all duration-300 placeholder-gray-400 dark:placeholder-gray-500 group-hover:border-yellow-500 dark:group-hover:border-yellow-600"
                                    placeholder="john@example.com"
                                />
                            </div>
                            <x-input-error :messages="$errors->get('email')" class="mt-1" />
                        </div>

                        <!-- Password -->
                        <div class="space-y-2 animate-slideUp" style="animation-delay: 300ms;">
                            <x-input-label for="password" :value="__('Password')" class="text-sm font-medium text-gray-700 dark:text-gray-300" />
                            <div class="relative group">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                    </svg>
                                </div>
                                <input 
                                    id="password"
                                    type="password"
                                    name="password"
                                    required
                                    autocomplete="new-password"
                                    class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-600 focus:border-transparent dark:text-gray-200 text-sm transition-all duration-300 placeholder-gray-400 dark:placeholder-gray-500 group-hover:border-yellow-500 dark:group-hover:border-yellow-600"
                                    placeholder="••••••••"
                                />
                            </div>
                            <x-input-error :messages="$errors->get('password')" class="mt-1" />
                        </div>

                        <!-- Confirm Password -->
                        <div class="space-y-2 animate-slideUp" style="animation-delay: 400ms;">
                            <x-input-label for="password_confirmation" :value="__('Confirm Password')" class="text-sm font-medium text-gray-700 dark:text-gray-300" />
                            <div class="relative group">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                    </svg>
                                </div>
                                <input 
                                    id="password_confirmation"
                                    type="password"
                                    name="password_confirmation"
                                    required
                                    class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-600 focus:border-transparent dark:text-gray-200 text-sm transition-all duration-300 placeholder-gray-400 dark:placeholder-gray-500 group-hover:border-yellow-500 dark:group-hover:border-yellow-600"
                                    placeholder="••••••••"
                                />
                            </div>
                            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-1" />
                        </div>
                            
                        <!-- Referral Code -->
                        <!--<div class="space-y-2 animate-slideUp" style="animation-delay: 450ms;">-->
                        <!--    <x-input-label for="referral_code" :value="__('Referral Code (Optional)')" class="text-sm font-medium text-gray-700 dark:text-gray-300" />-->
                        <!--    <div class="relative group">-->
                        <!--        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">-->
                        <!--            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">-->
                        <!--                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />-->
                        <!--            </svg>-->
                        <!--        </div>-->
                        <!--        @if(!empty($referrer))-->
                                    <!-- Hidden input to preserve referral code when disabled -->
                        <!--            <input type="hidden" name="referral_code" value="{{ $referral_code }}" />-->
                        <!--        @endif-->
                        <!--        <input -->
                        <!--            id="referral_code"-->
                        <!--            type="text"-->
                        <!--            name="{{ empty($referrer) ? 'referral_code' : '' }}"-->
                        <!--            value="{{ $referral_code }}"-->
                        <!--            {{ !empty($referrer) ? 'disabled' : '' }}-->
                        <!--            class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-600 focus:border-transparent dark:text-gray-200 text-sm transition-all duration-300 placeholder-gray-400 dark:placeholder-gray-500 group-hover:border-yellow-500 dark:group-hover:border-yellow-600"-->
                        <!--            placeholder="Enter referral code"-->
                        <!--        />-->
                        <!--    </div>-->
                        <!--    @if(!empty($referrer))-->
                        <!--        <div class="relative group mt-2">-->
                        <!--            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">-->
                        <!--                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">-->
                        <!--                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />-->
                        <!--                </svg>-->
                        <!--            </div>-->
                        <!--            <input -->
                        <!--                type="text"-->
                        <!--                value="Referred by: {{ $referrer->name }}"-->
                        <!--                disabled-->
                        <!--                class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 rounded-xl text-sm text-green-600 dark:text-green-400 cursor-not-allowed"-->
                        <!--            />-->
                        <!--        </div>-->
                        <!--    @endif-->
                        <!--    <div id="referral-status" class="mt-2 text-sm"></div>-->
                        <!--    <x-input-error :messages="$errors->get('referral_code')" class="mt-1" />-->
                        <!--</div>-->
                        
                                                <div style="display: none;">
                            <label for="website">Website</label>
                            <input type="text" name="website" id="website" autocomplete="off" />
                        </div>
                        
                        <!-- Google reCAPTCHA -->
                        <div class="space-y-2 animate-slideUp" style="animation-delay: 480ms;">
                            <div class="g-recaptcha" data-sitekey="6LfNLMMrAAAAAIq1NbDJnvXADcde7l6GyME-74ea"></div>
                            @if ($errors->has('g-recaptcha-response'))
                                <p class="mt-1 text-red-500 text-sm">{{ $errors->first('g-recaptcha-response') }}</p>
                            @endif
                        </div>





                        <!-- Register Button -->
                        <button
                            type="submit"
                            class="w-full px-4 py-3 mt-6 text-sm font-medium text-white bg-yellow-500 hover:bg-yellow-600 dark:bg-yellow-600 dark:hover:bg-yellow-700 rounded-xl transition-all duration-300 transform hover:scale-[1.02] hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 dark:focus:ring-offset-gray-800 animate-slideUp group"
                            style="animation-delay: 500ms;"
                        >
                            <span class="flex items-center justify-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2 transform transition-transform duration-300 group-hover:translate-x-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                                </svg>
                                {{ __('Create Account') }}
                            </span>
                        </button>
                    </form>

                  <!-- Login Link -->
                    <div class="mt-8 text-center animate-slideUp" style="animation-delay: 800ms;">
                        <p class="text-sm text-gray-600 dark:text-gray-400">
                            Already have an account? 
                            <a href="{{ route('login') }}" 
                               class="font-medium text-yellow-600 hover:text-yellow-700 dark:text-yellow-400 dark:hover:text-yellow-300 transition-all duration-300 hover:underline ml-1">
                                {{ __('Sign in') }}
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideUp {
            from { transform: translateY(20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        @keyframes slideDown {
            from { transform: translateY(-20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        .animate-fadeIn {
            animation: fadeIn 0.6s ease-out;
        }
        .animate-slideUp {
            opacity: 0;
            animation: slideUp 0.5s ease-out forwards;
        }
        .animate-slideDown {
            opacity: 0;
            animation: slideDown 0.5s ease-out forwards;
        }
    </style>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
  <script>
document.addEventListener('DOMContentLoaded', function() {
    const referralInput = document.getElementById('referral_code');
    const referralStatus = document.getElementById('referral-status');
    let typingTimer;

    // If there's a referral code from URL, verify it immediately
    const urlParams = new URLSearchParams(window.location.search);
    const refCode = urlParams.get('ref');
    if (refCode) {
        referralInput.value = refCode;
        verifyReferralCode();
    }

    // Handle manual input
    referralInput.addEventListener('input', function() {
        if (!this.disabled) {
            clearTimeout(typingTimer);
            if (this.value.length > 0) {
                typingTimer = setTimeout(verifyReferralCode, 500);
            } else {
                referralStatus.innerHTML = '';
            }
        }
    });

    function verifyReferralCode() {
        const code = referralInput.value;
        if (!code) return;

        fetch('{{ route('referral.verify') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ referral_code: code })
        })
        .then(response => response.json())
        .then(data => {
            if (data.valid) {
                // Create the referred by input
                let referredByHtml = `
                    <div class="relative group mt-2">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                        </div>
                        <input 
                            type="text"
                            value="Referred by: ${data.referrer}"
                            disabled
                            class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 rounded-xl text-sm text-green-600 dark:text-green-400 cursor-not-allowed"
                        />
                    </div>`;
                referralStatus.innerHTML = referredByHtml;
                referralInput.disabled = true;
            } else {
                referralStatus.innerHTML = '';
                referralInput.disabled = false;
            }
        })
        .catch(error => {
            referralStatus.innerHTML = '';
            referralInput.disabled = false;
        });
    }
});
</script>
</x-guest-layout>