<!DOCTYPE html>
<html x-data="{ darkMode: localStorage.getItem('darkMode') === 'true' }" :class="{ 'dark': darkMode }" lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ setting('site_name') }}</title>
    <link rel="icon" href="{{ asset(setting('site_favicon')) }}" type="image/x-icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap"
        rel="stylesheet" />

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

    <!-- Styles -->
    <link rel="stylesheet" href="{{ asset('css/scrollbar.css') }}">
    <!-- Vite Compiled CSS and JS -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles

    <script src="//code.jivosite.com/widget/UkL9j01jhH" async></script>


</head>

<body class="font-sans antialiased">

    {{ $slot }}


    <!-- Livewire Scripts -->
    @livewireScripts
    <script>
        // Initialize dark mode from localStorage
        if (localStorage.getItem('darkMode') === null) {
            localStorage.setItem('darkMode', window.matchMedia('(prefers-color-scheme: dark)').matches);
        }
    </script>

    <script>
        // Replace with same value as SESSION_LIFETIME (in minutes)
        let sessionLifetime = {{ config('session.lifetime') }} * 60;

        function startCountdown(duration) {
            let timer = duration,
                hours, minutes, seconds;
            const display = document.querySelector(".font-mono");
            const progress = document.querySelector(".bg-gradient-to-r");

            setInterval(function() {
                hours = Math.floor(timer / 3600);
                minutes = Math.floor((timer % 3600) / 60);
                seconds = timer % 60;

                display.textContent =
                    String(hours).padStart(2, "0") + ":" +
                    String(minutes).padStart(2, "0") + ":" +
                    String(seconds).padStart(2, "0");

                // Progress bar fill
                let percent = 100 - (timer / duration) * 100;
                progress.style.width = percent + "%";

                if (--timer < 0) {
                    display.textContent = "EXPIRED";
                }
            }, 1000);
        }

        document.addEventListener("DOMContentLoaded", () => {
            startCountdown(sessionLifetime);
        });
    </script>

    <script>
        let sessionLifetime = {{ config('session.lifetime') }} * 60;
        let status = document.getElementById("session-status");

        setInterval(() => {
            sessionLifetime--;
            if (sessionLifetime <= 0) {
                status.textContent = "Status: EXPIRED";
            }
        }, 1000);
    </script>

</body>

</html>
