<x-user-layout>
    <main class="w-full mx-auto h-auto bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4">
            <a href="{{ route('dashboard') }}" class="text-gray-400 hover:text-gray-300">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold">Buy {{ $asset['name'] }}</h1>
            <div class="w-8"></div>
        </div>

        <!-- Main Content -->
        <div class="p-4 flex flex-col items-center justify-center min-h-[calc(100vh-70px)]">
            <!-- Amount Input -->
            <div class="text-center mb-8">
                <div class="flex items-center justify-center text-4xl mb-2">
                    <span class="mr-2">$</span>
                    <input 
                        type="number" 
                        value="150" 
                        id="usdAmount"
                        class="w-32 bg-transparent text-center focus:outline-none text-4xl"
                        min="0"
                    >
                </div>
                <p class="text-gray-400">
                    ≈ <span id="cryptoAmount">{{ number_format(150 / $asset['price'], 8) }}</span> {{ $asset['symbol'] }}
                </p>
            </div>

            <!-- Payment Options -->
            <div class="w-full max-w-md space-y-4">
                <button onclick="togglePaymentModal()" class="w-full bg-gray-200 dark:bg-gray-800 hover:bg-gray-300 dark:hover:bg-gray-700 text-black dark:text-white rounded-lg p-4">
                    <div class="flex items-center justify-between">
                       <div class="flex items-center">
    <div class="w-8 h-8 bg-white rounded-full flex items-center justify-center mr-3">
        <i class="fas fa-credit-card text-black"></i>
    </div>
    <div class="text-left">
        <p id="selectedProviderName" class="text-yellow-500">Choose Payment Method</p>
        <p id="selectedProviderInstruction" class="text-sm text-gray-700 dark:text-gray-400">Select provider</p>
    </div>
</div>

                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </div>
                </button>

                <!-- Dynamic "Buy Now" Button -->
                <button id="buyButton" onclick="redirectToProvider()" class="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-4 rounded-lg transition-colors">
                    Buy {{ $asset['symbol'] }} Now
                </button>
            </div>
        </div>

        <!-- Payment Method Modal -->
<div id="paymentModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50" onclick="togglePaymentModal()">
    <div class="bg-gray-100 dark:bg-gray-900 w-full max-w-md rounded-lg p-6 mx-4" onclick="event.stopPropagation()">
        <!-- Modal Header -->
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-xl font-semibold">Payment Method</h2>
            <button onclick="togglePaymentModal()" class="text-gray-400 hover:text-gray-300">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <!-- Payment Methods -->
        <div class="space-y-4 mb-6">
            <label class="flex items-center space-x-3 cursor-pointer">
                <input type="radio" name="payment" value="binance" checked class="form-radio text-yellow-500">
                <span class="flex items-center">
                    <i class="fas fa-credit-card mr-2"></i>
                    Binance
                </span>
            </label>

            <label class="flex items-center space-x-3 cursor-pointer">
                <input type="radio" name="payment" value="transak" class="form-radio text-yellow-500">
                <span class="flex items-center">
                    <i class="fas fa-university mr-2"></i>
                    Transak
                </span>
            </label>

            <label class="flex items-center space-x-3 cursor-pointer">
                <input type="radio" name="payment" value="moonpay" class="form-radio text-yellow-500">
                <span class="flex items-center">
                    <i class="fas fa-mobile-alt mr-2"></i>
                    MoonPay
                </span>
            </label>
        </div>

        <!-- Confirm Payment Method Button -->
        <button onclick="updateSelectedProvider()" class="w-full bg-blue-500 hover:bg-blue-600 text-white font-semibold py-2 rounded-lg">
            Confirm Payment Method
        </button>
    </div>
</div>

    </main>

    @push('scripts')
<script>
function updateSelectedProvider() {
    const selectedRadio = document.querySelector('input[name="payment"]:checked');
    if (selectedRadio) {
        const selectedValue = selectedRadio.value;
        const providerMapping = {
            binance: 'Binance',
            transak: 'Transak',
            moonpay: 'MoonPay'
        };
        document.getElementById('selectedProviderName').textContent = providerMapping[selectedValue] || 'Choose Payment Method';
        document.getElementById('selectedProviderInstruction').textContent = 'Selected';
    }
    togglePaymentModal();
}

function togglePaymentModal() {
    const modal = document.getElementById('paymentModal');
    modal.classList.toggle('hidden');
}

function updateCryptoAmount() {
    const usdInput = document.getElementById('usdAmount');
    const usdAmount = parseFloat(usdInput.value) || 0;
    const price = Number("{{ $asset['price'] }}");
    const cryptoAmount = (usdAmount / price).toFixed(8);
    document.getElementById('cryptoAmount').textContent = cryptoAmount;
}

document.addEventListener('DOMContentLoaded', function() {
    updateCryptoAmount();
    document.getElementById('usdAmount').addEventListener('input', updateCryptoAmount);
});

function redirectToProvider() {
    const selectedPayment = document.querySelector('input[name="payment"]:checked');
    if (!selectedPayment) {
        alert('Please select a payment provider');
        return;
    }
    const selectedProvider = selectedPayment.value;

    let providerUrl = '';

    switch (selectedProvider) {
        case 'binance':
            providerUrl = 'https://www.binance.com/en/crypto/buy';
            break;
        case 'transak':
            providerUrl = 'https://transak.com/buy';
            break;
        case 'moonpay':
            providerUrl = "https://www.moonpay.com/buy/{{ strtolower($asset['symbol']) }}";
            break;
        default:
            alert('Invalid payment provider selected');
            return;
    }

    // Open in a new tab instead of redirecting
    window.open(providerUrl, '_blank');
}
</script>

    @endpush
</x-user-layout>
