<x-user-layout>
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8 pb-4">
            <a href="{{ url()->previous() }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Manage Crypto</h1>
            <div class="w-8"></div> <!-- Spacer for centering -->
        </div>
    
        <!-- Crypto List -->
        <div class="space-y-4">
            @foreach($cryptos as $crypto)
                <div class="flex items-center justify-between p-4 crypto-item" data-crypto="{{ strtolower($crypto['symbol']) }}">
                    <div class="flex items-center">
                        <div class="w-10 h-10 rounded-full flex items-center justify-center mr-4">
                            @if(strtolower($crypto['symbol']) === 'usdt')
                                <!-- USDT Icon as Text -->
                                <span class="text-white font-bold">₮</span>
                            @else
                                <!-- Cryptocurrency Icon as Image -->
                                <img 
                                    src="{{ asset('images/' . strtolower($crypto['symbol']) . '-icon.png') }}" 
                                    alt="{{ $crypto['name'] }} Icon" 
                                    class="w-8 h-8 object-contain"
                                >
                            @endif
                        </div>
                        <div>
                            <h3 class="font-semibold">{{ $crypto['symbol'] }}</h3>
                            <p class="text-sm text-gray-400">{{ $crypto['name'] }}</p>
                        </div>
                    </div>
                    <div class="relative inline-flex items-center cursor-pointer">
                        <input 
    type="checkbox" 
    class="sr-only peer crypto-toggle" 
    {{ $crypto['status'] === true ? 'checked' : '' }}
    data-crypto="{{ strtolower($crypto['symbol']) }}"
    id="crypto-toggle-{{ strtolower($crypto['symbol']) }}"
>
<label 
    for="crypto-toggle-{{ strtolower($crypto['symbol']) }}" 
    class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600 cursor-pointer"
></label>
                    </div>
                </div>
            @endforeach
        </div>
    </main>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.crypto-toggle').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const cryptoSymbol = this.getAttribute('data-crypto');
            const isChecked = this.checked;

            fetch('{{ route('crypto.manage.update') }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    crypto: cryptoSymbol,
                    status: isChecked ? 1 : 0
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Create success message element if it doesn't exist
                    let successMsg = document.getElementById('crypto-success-message');
                    if (!successMsg) {
                        successMsg = document.createElement('div');
                        successMsg.id = 'crypto-success-message';
                        successMsg.className = 'fixed top-4 right-4 bg-green-500 text-white px-4 py-2 rounded shadow-lg z-50';
                        document.body.appendChild(successMsg);
                    }

                    // Set and show success message
                    successMsg.textContent = `Status updated successfully`;
                    successMsg.classList.remove('hidden');

                    // Automatically hide the message after 3 seconds
                    setTimeout(() => {
                        successMsg.classList.add('hidden');
                    }, 3000);
                } else {
                    // Revert the checkbox if update fails
                    this.checked = !isChecked;
                    
                    // Show error message
                    alert(data.message || 'Failed to update crypto status');
                }
            })
            .catch(error => {
                // Revert the checkbox
                this.checked = !isChecked;
                
                alert('An error occurred while updating crypto status');
            });
        });
    });
});
</script>
@endpush
</x-user-layout>