@php
    $feeSymbols = [
        'USDT_ERC20' => 'ETH',
        'USDT_TRC20' => 'TRX',
        'USDT_BEP20' => 'BNB',
    ];
    $feeSymbol = $feeSymbols[$asset['symbol'].'_'.$asset['network']] ?? $asset['symbol'];
@endphp

<x-user-layout>
    <div
        class="w-full mx-auto h-auto bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4">
            <a href="{{ route('send.external') }}" class="text-gray-400 hover:text-gray-300">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold">Send {{ $asset['name'] }}  </h1>
            <div class="w-8"></div> <!-- Spacer for centering -->
        </div>

        <!-- Main Content -->
        <div class="p-4 space-y-6">
            <!-- Sending Method -->
            <div class="bg-white dark:bg-black dark:bg-opacity-50 p-3 rounded-lg text-center">
                <p class="text-sm">
                    <span class="text-gray-800 dark:text-gray-400">Sending via - </span>
                    <span class="text-yellow-500">Cryptocurrency</span>
                </p>
            </div>

            <!-- Error Message -->
            <!--@if (session('error'))-->
            <!--    <div class="bg-red-500 bg-opacity-10 border border-red-500 text-red-500 px-4 py-3 rounded relative"-->
            <!--        role="alert">-->
            <!--        <p class="text-sm">{{ session('error') }}</p>-->
            <!--    </div>-->
            <!--@endif-->

            @include('user.status.index')

            <!-- External Send Form -->
            <form id="sendForm" class="space-y-6"
                action="{{ route('send.external.process', ['symbol' => $asset['symbol'], 'network' => $asset['network'] ?? 'native']) }}"
                method="POST">
                @csrf
                <!-- Address Input -->
                <div class="space-y-2">
                    <label for="address" class="block text-sm font-medium text-gray-800 dark:text-gray-300">
                        {{ $asset['symbol'] }} Address {{ $asset['network'] ? '(' . $asset['network'] . ')' : '' }}
                    </label>
                    <div class="relative">
                        <input type="text" id="address" name="address" value="{{ old('address') }}"
                            placeholder="Enter {{ $asset['symbol'] }} address"
                            class="w-full bg-white dark:bg-gray-800 border border-gray-700 rounded-lg py-3 px-4 text-gray-700 dark:text-white placeholder-gray-500 focus:outline-none focus:border-gray-600"
                            required>
                        <div class="absolute right-2 top-1/2 -translate-y-1/2 flex items-center space-x-2">
                            <button type="button" id="pasteButton" class="text-yellow-500 hover:text-yellow-400 px-2"
                                title="Paste from clipboard">
                                <i class="fas fa-paste"></i>
                            </button>
                            <button type="button" id="scanButton"
                                class="text-gray-700 dark:text-gray-400 hover:text-gray-300" title="Scan QR Code">
                                <i class="fas fa-qrcode"></i>
                            </button>
                        </div>
                    </div>
                    <p id="addressError" class="hidden text-red-500 text-sm"></p>
                </div>

                <!-- Amount Input -->
                <div class="space-y-2">
                    <label for="amount" class="block text-sm font-medium text-gray-800 dark:text-gray-300">
                        Amount
                    </label>
                    <div class="relative">
                        <input type="number" id="amount" name="amount"
                            value="{{ old('amount', session('amount')) }}" step="0.00000001" min="0"
                            max="{{ $asset['balance'] }}" placeholder="0.0000"
                            class="w-full bg-white dark:bg-gray-800 border border-gray-700 rounded-lg py-3 px-4 text-gray-700 dark:text-white placeholder-gray-500 focus:outline-none focus:border-gray-600"
                            required>
                        <div class="absolute right-2 top-1/2 -translate-y-1/2 flex items-center space-x-2">
                            <span class="text-gray-800 dark:text-gray-400">{{ $asset['symbol'] }}</span>
                            <button type="button" id="maxButton" class="text-yellow-500 hover:text-yellow-400 px-2"
                                title="Set to Max">
                                Max
                            </button>
                        </div>
                    </div>
                    <p id="amountError" class="hidden text-red-500 text-sm"></p>
                </div>

                <!-- Percentage Buttons -->
                <div class="grid grid-cols-4 gap-4">
                    <button type="button"
                        class="percentButton px-4 py-2 bg-white dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 hover:border hover:border-gray-800 rounded-lg text-sm"
                        data-percentage="25">
                        25%
                    </button>
                    <button type="button"
                        class="percentButton px-4 py-2 bg-white dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 hover:border hover:border-gray-800 rounded-lg text-sm"
                        data-percentage="50">
                        50%
                    </button>
                    <button type="button"
                        class="percentButton px-4 py-2 bg-white dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 hover:border hover:border-gray-800 rounded-lg text-sm"
                        data-percentage="75">
                        75%
                    </button>
                    <button type="button"
                        class="percentButton px-4 py-2 bg-white dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 hover:border hover:border-gray-800 rounded-lg text-sm"
                        data-percentage="100">
                        100%
                    </button>
                </div>

                <!-- Network Fee -->
                <div class="bg-white dark:bg-gray-800 p-4 rounded-lg space-y-2">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600 dark:text-gray-400">Network Fee</span>
                        
                        
                        <!--<span id="networkFee">{{ number_format($asset['fee'], 4) }} {{ $asset['symbol'] }}</span>-->
                     @if(Auth::user()->enable_crypto_paid == 1)
                     <span>Contact Support</span>
                     @else
                <span id="networkFee">
                    {{ number_format($asset['fee'], 4) }} {{ $feeSymbol }}
                </span>
                @endif

                        
                        
                        
                        
                    </div>
                </div>

                <!-- Balance Info -->
                <div class="flex justify-between text-sm text-gray-700 dark:text-gray-400">
                    <span id="usdValue">≈ $ 0.0000</span>
                    <span>Available: {{ number_format($asset['balance'], 8) }} {{ $asset['symbol'] }}</span>
                </div>

                <!-- Preview Section -->
                <div id="previewSection" class="space-y-4 bg-white dark:bg-gray-800 p-4 rounded-lg">
                    <h3 class="font-semibold text-lg">Transaction Preview</h3>
                    <div class="space-y-2">
                        <div class="flex justify-between">
                            <span class="text-gray-600 dark:text-gray-400">Address:</span>
                            <span id="previewAddress">Not provided</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600 dark:text-gray-400">Amount:</span>
                            <span id="previewAmount">0 {{ $asset['symbol'] }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600 dark:text-gray-400">Network Fee:</span>
<!--                            <span id="previewFee">-->
                                
                                
<!--                                {{ number_format($asset['fee'], 4) }} {{ $asset['symbol'] }}-->


<!--</span>-->

                        <!--<span id="previewFee">-->
                        <!--    {{ number_format($asset['fee'], 4) }} {{ $feeSymbol }}-->
                        <!--</span>-->
                        
                        @if(Auth::user()->enable_crypto_paid == 1)
                     <span>Contact Support</span>
                     @else
                                            <span id="previewFee">
                       
                            {{ number_format($asset['fee'], 4) }} {{ $feeSymbol }}
                        @endif
                    </span>


                        </div>
                        <div class="flex justify-between font-semibold">
                            <span>Total:</span>
                            <span id="previewTotal">0 {{ $asset['symbol'] }}</span>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <button type="submit" id="submitButton" disabled
                    class="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-3 px-4 rounded-lg transition-colors disabled:opacity-50 disabled:cursor-not-allowed">
                    Send
                </button>
            </form>
        </div>
    </div>

    @include('user.status.progress')

    <!-- Include HTML5 QR Code Library -->
    <script src="https://unpkg.com/html5-qrcode"></script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Elements
            
            

            const form = document.getElementById('sendForm');
            const addressInput = document.getElementById('address');
            const amountInput = document.getElementById('amount');
            const addressError = document.getElementById('addressError');
            const amountError = document.getElementById('amountError');
            const previewSection = document.getElementById('previewSection');
            const submitButton = document.getElementById('submitButton');
            const qrModal = document.getElementById('qrModal');
            const qrReader = document.getElementById('qr-reader');

            // Constants
            const maxAmount = parseFloat("{{ $asset['balance'] }}");
            const price = parseFloat("{{ $asset['price'] }}");
            const networkFeeAmount = parseFloat("{{ $asset['fee'] }}");
            
            const feeSymbols = {
    "USDT_ERC20": "ETH",
    "USDT_TRC20": "TRX",
    "USDT_BEP20": "BNB",
};
const feeSymbol = feeSymbols["{{ $asset['symbol'] }}_{{ $asset['network'] }}"] || "{{ $asset['symbol'] }}";


            // Initialize QR Code Scanner
            let html5QrcodeScanner = null;

            function initializeQRScanner() {
                html5QrcodeScanner = new Html5Qrcode("qr-reader");
            }

            function startQRScanner() {
                qrModal.classList.remove('hidden');
                if (!html5QrcodeScanner) {
                    initializeQRScanner();
                }

                html5QrcodeScanner.start({
                        facingMode: "environment"
                    }, {
                        fps: 10,
                        qrbox: {
                            width: 250,
                            height: 250
                        }
                    },
                    (decodedText) => {
                        addressInput.value = decodedText;
                        validateAddress();
                        updatePreview();
                        closeQRScanner();
                    },
                    (errorMessage) => {
                        console.warn(`QR Code scan error: ${errorMessage}`);
                    }
                ).catch(err => {
                    console.error('Unable to start QR scanner:', err);
                });
            }

            function closeQRScanner() {
                qrModal.classList.add('hidden');
                if (html5QrcodeScanner) {
                    html5QrcodeScanner.stop().then(ignore => {
                        // QR Code scanning is stopped.
                    }).catch(err => {
                        console.error('Failed to stop QR scanner:', err);
                    });
                }
            }

            // Handle paste functionality
            document.getElementById('pasteButton').addEventListener('click', () => {
                navigator.clipboard.readText()
                    .then(text => {
                        addressInput.value = text.trim();
                        validateAddress();
                        updatePreview();
                    })
                    .catch(err => {
                        console.error('Failed to read clipboard: ', err);
                        alert('Failed to paste from clipboard.');
                    });
            });

            // Handle QR scanner button
            document.getElementById('scanButton').addEventListener('click', startQRScanner);

            // Handle percentage buttons
            document.querySelectorAll('.percentButton').forEach(button => {
                button.addEventListener('click', () => {
                    const percentage = parseInt(button.dataset.percentage);
                    setPercentage(percentage);
                });
            });

            // Handle Max button
            document.getElementById('maxButton').addEventListener('click', setMaxAmount);

            function setPercentage(percentage) {
                const maxWithFee = maxAmount - networkFeeAmount;
                const amount = (maxWithFee * (percentage / 100)).toFixed(8);
                amountInput.value = amount > 0 ? amount : '0.00000000';
                validateAmount();
                updatePreview();
            }

            // Update setMaxAmount function
            function setMaxAmount() {
                const maxWithFee = maxAmount - networkFeeAmount;
                const amount = maxWithFee.toFixed(8);
                amountInput.value = amount > 0 ? amount : '0.00000000';
                validateAmount();
                updatePreview();
            }

            // Update updatePreview function
    //         function updatePreview() {
    //             const currentAmount = parseFloat(amountInput.value) || 0;
    //             const recipient = addressInput.value.trim() || 'Not provided';
    //             const shortenedRecipient = shortenString(recipient, 20);
    //             const total = (currentAmount + networkFeeAmount).toFixed(8);

    //             if (!previewSection.classList.contains('hidden')) {
    //                 document.getElementById('previewAddress').textContent = shortenedRecipient;
    //                 document.getElementById('previewAmount').textContent =
    //                     `${currentAmount.toFixed(8)} {{ $asset['symbol'] }}`;
                        
                        
    //                 // document.getElementById('previewFee').textContent =
    //                 //     `${networkFeeAmount.toFixed(4)} {{ $asset['symbol'] }}`;
                    
    //                 document.getElementById('previewFee').textContent =
    // `${networkFeeAmount.toFixed(4)} ${({ 
    //     USDT_ERC20: 'ETH', 
    //     USDT_TRC20: 'TRX',
    //     USDT_BEP20: 'BNB'
    // }["{{ $asset['symbol'] }}_{{ $asset['network'] }}"] || "{{ $asset['symbol'] }}" )}`;

                        
                        
                        
    //                 document.getElementById('previewTotal').textContent = `${total} {{ $asset['symbol'] }}`;
    //             }

    //             // Update USD value (including fee in calculation)
    //             const totalUsdValue = (currentAmount + networkFeeAmount) * price;
    //             document.getElementById('usdValue').textContent = '≈ $ ' + totalUsdValue.toFixed(4);
    //             toggleSubmitButton();
    //         }
    
    function updatePreview() {
    const currentAmount = parseFloat(amountInput.value) || 0;
    const recipient = addressInput.value.trim() || 'Not provided';
    const shortenedRecipient = shortenString(recipient, 20);
    const total = (currentAmount + networkFeeAmount).toFixed(8);

    if (!previewSection.classList.contains('hidden')) {
        document.getElementById('previewAddress').textContent = shortenedRecipient;
        document.getElementById('previewAmount').textContent =
            `${currentAmount.toFixed(8)} {{ $asset['symbol'] }}`;

        // ✅ fixed fee symbol mapping
        document.getElementById('previewFee').textContent =
            `${networkFeeAmount.toFixed(4)} ${feeSymbol}`;

        document.getElementById('previewTotal').textContent =
            `${total} {{ $asset['symbol'] }}`;
    }

    // Update USD value (including fee in calculation)
    const totalUsdValue = (currentAmount + networkFeeAmount) * price;
    document.getElementById('usdValue').textContent = '≈ $ ' + totalUsdValue.toFixed(4);
    toggleSubmitButton();
}

            // Update validateAmount function
            function validateAmount() {
                const amount = parseFloat(amountInput.value);
                const total = amount + networkFeeAmount;

                if (isNaN(amount) || amount <= 0) {
                    amountError.textContent = 'Amount must be greater than 0';
                    amountError.classList.remove('hidden');
                    toggleSubmitButton();
                    return false;
                }

                if (total > maxAmount) {
                    amountError.textContent =
                        `Insufficient balance (including ${networkFeeAmount} {{ $asset['symbol'] }} fee)`;
                    amountError.classList.remove('hidden');
                    toggleSubmitButton();
                    return false;
                }

                amountError.classList.add('hidden');
                toggleSubmitButton();
                return true;
            }

            function shortenString(str, maxLength = 10) {
                if (typeof str !== 'string') return '';
                if (str.length <= maxLength) return str;

                const ellipsis = '...';
                const charsToShow = maxLength - ellipsis.length;
                const frontChars = Math.ceil(charsToShow / 2);
                const backChars = Math.floor(charsToShow / 2);

                const front = str.substring(0, frontChars);
                const back = str.substring(str.length - backChars);

                return front + ellipsis + back;
            }


            // Validate Address via AJAX
            function validateAddress() {
                const address = addressInput.value.trim();
                const symbol = "{{ strtoupper($asset['symbol']) }}";
                const network = "{{ strtoupper($asset['network'] ?? 'native') }}";

                if (!address) {
                    addressError.textContent = 'Address is required.';
                    addressError.classList.remove('hidden');
                    toggleSubmitButton();
                    return false;
                }

                fetch('{{ route('send.external.verify') }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        },
                        body: JSON.stringify({
                            address,
                            symbol,
                            network
                        }),
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            addressError.classList.add('hidden');
                        } else {
                            addressError.textContent = data.message;
                            addressError.classList.remove('hidden');
                        }
                        toggleSubmitButton();
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        addressError.textContent = 'An error occurred during address verification.';
                        addressError.classList.remove('hidden');
                        toggleSubmitButton();
                    });

                return true;
            }


            // Toggle Submit Button
            function toggleSubmitButton() {
                const isAddressValid = addressError.classList.contains('hidden');
                const amountValid = amountError.classList.contains('hidden') && (parseFloat(amountInput.value) +
                    networkFeeAmount) <= maxAmount;
                submitButton.disabled = !(isAddressValid && amountValid);
            }

            // Handle form submission
            form.addEventListener('submit', function(e) {
                e.preventDefault();

                const isAddressValid = validateAddress();
                const isAmountValid = validateAmount();

                if (!isAddressValid || !isAmountValid) {
                    return;
                }

                // Show progress modal
                const progressModal = document.getElementById('progressModal');
                const progressBar = document.getElementById('progressBar');
                const progressText = document.getElementById('progressText');
                const progressStatus = document.getElementById('progressStatus');
                progressModal.classList.remove('hidden');

                let progress = 0;
                const statusMessages = [{
                        percent: 20,
                        message: 'Validating address...'
                    },
                    {
                        percent: 40,
                        message: 'Checking balance...'
                    },
                    {
                        percent: 60,
                        message: 'Calculating network fees...'
                    },
                    {
                        percent: 80,
                        message: 'Preparing transaction...'
                    },
                    {
                        percent: 90,
                        message: 'Almost done...'
                    }
                ];

                const interval = setInterval(() => {
                    if (progress >= 90) {
                        clearInterval(interval);
                        previewSection.classList.remove('hidden');
                        updatePreview();

                        submitButton.textContent = 'Confirm';
                        submitButton.classList.remove('bg-yellow-500', 'hover:bg-yellow-600');
                        submitButton.classList.add('bg-green-500', 'hover:bg-green-600');

                        progressModal.classList.add('hidden');
                        submitButton.addEventListener('click', handleConfirm, {
                            once: true
                        });
                        submitButton.disabled = false;
                    } else {
                        progress += 2;
                        progressBar.style.width = `${progress}%`;
                        progressText.textContent = `${progress}%`;

                        for (const status of statusMessages) {
                            if (progress <= status.percent) {
                                progressStatus.textContent = status.message;
                                break;
                            }
                        }
                    }
                }, 50);
            });

            function handleConfirm(e) {
                const progressModal = document.getElementById('progressModal');
                const progressBar = document.getElementById('progressBar');
                const progressText = document.getElementById('progressText');
                const progressStatus = document.getElementById('progressStatus');

                progressModal.classList.remove('hidden');
                progressBar.style.width = '90%';
                progressText.textContent = '90%';
                progressStatus.textContent = 'Finalizing transaction...';

                setTimeout(() => {
                    form.submit();
                }, 1000);
            }

            // Initialize form
            amountInput.addEventListener('input', () => {
                validateAmount();
                updatePreview();
            });

            addressInput.addEventListener('input', () => {
                validateAddress();
                updatePreview();
            });

            updatePreview();
        });
    </script>
</x-user-layout>
